system module intrface

import objectfiles
from ostypes   import Rect
from ostoolbox import OSToolbox
from osrgn     import OSRgnHandle


::	CSTR	:==  Int
::	ACCLPTR	:==  Int
::	HDC		:==  Int
::	HWND	:==  Int
::	HITEM	:==  Int
::	HMENU	:==  Int
::	HRGN	:==  Int	// PA: new type def
::	Fnt
	:== (	!{#Char}
		,	!Int
		,	!Int
		)
::	RGBcolor
	:==	(	!Int
		,	!Int
		,	!Int
		)
::	Pt
	:== (	!Int
		,	!Int
		)
::	*PIC
	:== (	!HDC
		,	!*OSToolbox
		)
::	CrossCallInfo
	=	{	ccMsg	:: !Int
		,	p1		:: !Int
		,	p2		:: !Int
		,	p3		:: !Int
		,	p4		:: !Int
		,	p5		:: !Int
		,	p6		:: !Int
		}

MaxRand				:== 32767

iWhitePattern		:== 4
iLtGreyPattern		:== 3
iGreyPattern		:== 2
iDkGreyPattern		:== 1
iBlackPattern		:== 0

iModeNotBic			:== 7
iModeNotXor			:== 6
iModeNotOr			:== 5
iModeNotCopy		:== 4
iModeBic			:== 3
iModeXor			:== 2
iModeOr				:== 1
iModeCopy			:== 0

iStrikeOut			:== 8
iUnderline			:== 4
iItalic				:== 2
iBold				:== 1

WinHelpKey			:== 5
WinEscapeKey		:== 27
WinEnterKey			:== 3
WinReturnKey		:== 13
WinTabKey			:== 9
WinDelKey			:== 127
WinBackSpKey		:== 8
WinEndKey			:== 4
WinBeginKey			:== 1
WinPgDownKey		:== 12
WinPgUpKey			:== 11
WinRightKey			:== 29
WinLeftKey			:== 28
WinDownKey			:== 31
WinUpKey			:== 30
WinF1Key			:==	1001
WinF2Key			:==	1002
WinF3Key			:==	1003
WinF4Key			:==	1004
WinF5Key			:==	1005
WinF6Key			:==	1006
WinF7Key			:==	1007
WinF8Key			:==	1008
WinF9Key			:==	1009
WinF10Key			:==	1010
WinF11Key			:==	1011
WinF12Key			:==	1012

CTRLBIT				:== 4
ALTBIT				:== 2
SHIFTBIT			:== 1

KEYREPEAT			:== 4
KEYUP				:== 2
KEYDOWN				:== 1

BUTTONUP			:== 50
BUTTONSTILLDOWN		:== 40
BUTTONTRIPLEDOWN	:== 3
BUTTONDOUBLEDOWN	:== 2
BUTTONDOWN			:== 1
BUTTONSTILLUP		:== 0		/* PA: new constant for passing mouse move events. */

CURSHIDDEN			:== 6
CURSARROW			:== 5
CURSFATCROSS		:== 4
CURSCROSS			:== 3
CURSIBEAM			:== 2
CURSBUSY			:== 1

//	PA: constants for handling scrollbars.
SB_HORZ				:== 0
SB_VERT				:== 1
SB_CTL				:== 2
SB_BOTH				:== 3

SB_LINEUP			:== 0
SB_LINELEFT			:== 0
SB_LINEDOWN			:== 1
SB_LINERIGHT		:== 1
SB_PAGEUP			:== 2
SB_PAGELEFT			:== 2
SB_PAGEDOWN			:== 3
SB_PAGERIGHT		:== 3
SB_THUMBPOSITION	:== 4
SB_THUMBTRACK		:== 5
SB_TOP				:== 6
SB_LEFT				:== 6
SB_BOTTOM			:== 7
SB_RIGHT			:== 7
SB_ENDSCROLL		:== 8
//	PA: end of addition.

//	PA: constants for handling window styles.
WS_OVERLAPPED		:== 0x00000000
WS_POPUP			:== 0x80000000
WS_CHILD			:== 0x40000000
WS_MINIMIZE			:== 0x20000000
WS_VISIBLE			:== 0x10000000
WS_DISABLED			:== 0x08000000
WS_CLIPSIBLINGS		:== 0x04000000
WS_CLIPCHILDREN		:== 0x02000000
WS_MAXIMIZE			:== 0x01000000
WS_CAPTION			:== 0x00C00000		/* WS_BORDER | WS_DLGFRAME  */
WS_BORDER			:== 0x00800000
WS_DLGFRAME			:== 0x00400000
WS_VSCROLL			:== 0x00200000
WS_HSCROLL			:== 0x00100000
WS_SYSMENU			:== 0x00080000
WS_THICKFRAME		:== 0x00040000
WS_GROUP			:== 0x00020000
WS_TABSTOP			:== 0x00010000

WS_MINIMIZEBOX		:== 0x00020000
WS_MAXIMIZEBOX		:== 0x00010000

WS_TILED			:== WS_OVERLAPPED
WS_ICONIC			:== WS_MINIMIZE
WS_SIZEBOX			:== WS_THICKFRAME
//	PA: end of addition.

//	PA: constants for stacking windows.
HWND_TOP			:==	0
HWND_BOTTOM			:==	1
HWND_TOPMOST		:== -1
HWND_NOTOPMOST		:==	-2
//	PA: end of addition.

//	PA: constants for drawing polygons.
ALTERNATE			:== 1
WINDING				:== 2
//	PA: end of addition.

//	PA: CombineRgn() Styles.
RGN_AND				:== 1
RGN_OR				:== 2
RGN_XOR				:== 3
RGN_DIFF			:== 4
RGN_COPY			:== 5
//	PA: end of addition.

//	PA: Predefined Clipboard Formats.
CF_TEXT             :==	1
CF_BITMAP           :==	2
CF_METAFILEPICT     :==	3
CF_SYLK             :==	4
CF_DIF              :==	5
CF_TIFF             :==	6
CF_OEMTEXT          :==	7
CF_DIB              :==	8
CF_PALETTE          :==	9
CF_PENDATA          :==	10
CF_RIFF             :==	11
CF_WAVE             :==	12
CF_UNICODETEXT      :==	13
CF_ENHMETAFILE      :==	14
//	PA: end of addition.

//	PA: flag values for passing information about edit controls from Clean to OS.
EDITISMULTILINE		:==	1			/* PA: flag value: edit control is multi-line. */
EDITISKEYSENSITIVE	:==	2			/* PA: flag value: edit control sends keyboard events to Clean. */
//	PA: end of addition.

//	Constants for passing messages from Clean to OS.
// MW...
CcRqDO_PRINT_SETUP			:== 1828
CcRqDO_HTML_HELP			:==	1827
CcRqGET_PRINTER_DC			:== 1824
CcRqDISPATCH_MESSAGES_WHILE_PRINTING
							:== 1823
CcRqENDDOC					:== 1822
CcRqSTARTDOC				:== 1821
// ... MW

CcRqIDLETIMER			:== 1820

CcRqCLIPBOARDHASTEXT	:== 1812
CcRqGETCLIPBOARDTEXT	:== 1811
CcRqSETCLIPBOARDTEXT	:== 1810

CcRqFILESAVEDIALOG		:== 1801
CcRqFILEOPENDIALOG		:== 1800

CcRqSHOWCONTROL			:== 1755		/* PA: added */
CcRqSELECTPOPUPITEM		:== 1754
CcRqENABLEPOPUPITEM		:== 1753
CcRqADDTOPOPUP			:== 1752
CcRqSETITEMCHECK		:== 1751
CcRqENABLECONTROL		:== 1750

CcRqCREATECOMPOUND		:== 1729		/* PA: added */
CcRqCREATESCROLLBAR		:== 1728		/* PA: added */
CcRqCREATECUSTOM		:== 1727
CcRqCREATEICONBUT		:== 1726
CcRqCREATEPOPUP			:== 1725
CcRqCREATECHECKBOX		:== 1724
CcRqCREATERADIOBUT		:== 1723
CcRqCREATEEDITTXT		:== 1722
CcRqCREATESTATICTXT		:== 1721
CcRqCREATEBUTTON		:== 1720

CcRqGETACTIVEDIALOG		:== 1712
CcRqENDMODALDLOG		:== 1711
CcRqMODALDIALOG			:== 1710

CcRqCREATEDIALOG		:== 1700

CcRqGETBLINKTIME		:== 1670

CcRqWAIT				:== 1660

CcRqGETCURDATE			:== 1651
CcRqGETCURTIME			:== 1650

CcRqKILLTIMER			:== 1601
CcRqCREATETIMER			:== 1600

CcCbFONTSIZE			:== 1530

CcCbFONTNAME			:== 1520

CcRqGETFONTSIZES		:== 1510

CcRqGETFONTNAMES		:== 1500

CcRqRESTACKWINDOW		:==	1434		/* PA: added to restack windows. */
CcRqSHOWWINDOW			:==	1433		/* PA: added to (hide/show) windows. */
CcRqSETWINDOWSIZE		:==	1432		/* PA: added to resize windows/controls. */
CcRqSETSELECTWINDOW		:== 1431		/* PA: added to (en/dis)able windows. */
CcRqSETWINDOWPOS		:== 1430		/* PA: added to move windows/controls. */
CcRqINVALIDATERECT		:== 1429		/* PA: added for invalidating parts of a window/control. */
CcRqSETEDITSELECTION	:== 1428		/* PA: added for handling edit control selections. */
CcRqSETSCROLLSIZE		:==	1427		/* PA: added for setting thumb size of scrollbar. */
CcRqSETSCROLLPOS		:== 1426		/* PA: added for setting thumb of scrollbar. */
CcRqSETSCROLLRANGE		:== 1425		/* PA: added for setting range of scrollbar. */
CcRqRESETCURSOR			:== 1424
CcRqSETGLOBALCURSOR		:== 1423
CcRqOBSCURECURSOR		:== 1422
CcRqCHANGEWINDOWCURSOR	:== 1421
CcRqFIXEDTOSCROLL		:== 1420
CcRqRESIZEFIXED			:== 1419
CcRqRESIZESCROLL		:== 1418
CcRqGETSCROLLFRAME		:== 1417
CcRqGETWINDOWPOS		:== 1416
CcRqGETCLIENTSIZE		:== 1415
CcRqSCROLLWINDOW		:== 1414
CcRqSETVSCROLLINFO		:== 1413
CcRqSETHSCROLLINFO		:== 1412
CcRqGETWINDOWTEXT		:== 1411
CcRqSETWINDOWTITLE		:== 1410
CcRqSETFOREGROUNDWINDOW	:== 1409
CcRqGETFOREGROUNDWINDOW	:== 1408
CcRqINVALIDATEWINDOW	:== 1407
CcRqRELEASEDC			:== 1406
CcRqGETDC				:== 1405
CcRqENDPAINT			:== 1404
CcRqBEGINPAINT			:== 1403
CcRqDESTROYWINDOW		:== 1402
CcRqCREATESCROLLWINDOW	:== 1401
CcRqCREATEFIXEDWINDOW	:== 1400

CcRqMSGBOX				:== 1300

CcRqDRAWMBAR			:== 1265

CcRqCREATEMENUWINDOW	:== 1260		// PA: first MENU code

CcRqCREATEPOPMENU		:== 1255

CcRqCREATEMBAR			:== 1250

CcRqINSERTSEPARATOR		:== 1245

CcRqAPPENDSEPARATOR		:== 1240

CcRqMENUENABLE			:== 1235

CcRqMODIFYMENU			:== 1230

CcRqINSERTMENU			:==	1226		// PA: new constant for inserting a new menu into the menu bar
CcRqAPPENDMENU			:== 1225

CcRqITEMENABLE			:== 1220

CcRqMODIFYMENUITEM		:== 1215
CcRqDESTROYMENU			:== 1214		// PA: new constant for destroying a menu 'physically'
CcRqDELETEMENU			:==	1213		// PA: new constant for deleting a menu logically
CcRqREMOVEMENUITEM		:== 1212

CcRqCHECKMENUITEM		:== 1210

CcRqINSERTMENUITEM		:== 1205

CcRqAPPENDMENUITEM		:== 1200		// PA: last MENU code

CcRqDOMESSAGE			:== 1100

CcRqBEEP				:== 1001
CcRqCREATEWINDOW		:== 1000


//	Constants for passing messages from OS to Clean.
CcWINMESSmax			:== 999

CcWmINETEVENT				:==	140	/* MW */
CcWmDRAWCLIPBOARD		:==	126		/* PA: new constant for clipboard handling. Copied from Ronny. */
CcWmGETSCROLLBARINFO	:==	125		/* PA: new constant for info about scrollbars. */
CcWmSCROLLBARACTION		:== 124		/* PA: new constant for scrollbar handling. */
CcWmDDEEXECUTE			:== 123
CcWmLOSEMODELESSDLOG	:== 122
CcWmSETCURSOR			:== 121
CcWmDRAWCONTROL			:== 120
CcWmCOMBOSELECT			:== 119
CcWmBUTTONCLICKED		:== 118
CcWmINITDIALOG			:== 117
CcWmIDLETIMER			:== 116
CcWmTIMER				:== 115
CcWmNEWVTHUMB			:== 114
CcWmNEWHTHUMB			:== 113
CcWmGETVSCROLLVAL		:== 112
CcWmGETHSCROLLVAL		:== 111
CcWmSIZE				:== 110		/* PA: old constant reused for passing resize information. */
CcWmMOUSE				:== 109
CcWmKEYBOARD			:== 108
CcWmDEACTIVATE			:== 107
CcWmACTIVATE			:== 106
CcWmCLOSE				:== 105
CcWmGETMINMAXINFO		:== 104
CcWmCOMMAND				:== 103
CcWmCHAR				:== 102
CcWmCREATE				:== 101
CcWmPAINT				:== 100

CcWINMESSmin			:== 100

CcWmNOTIFY				:== 78

CcRETURNmax				:== 19

CcRETURN6				:== 16
CcRETURN5				:== 15
CcRETURN4				:== 14
CcRETURN3				:== 13
CcRETURN2				:== 12
CcRETURN1				:== 11
CcRETURN0				:== 10

CcRETURNmin				:== 10

CcWASQUIT				:== 1


WinLaunchApp			:: !{#Char} !Bool !*OSToolbox -> ( !Bool, !*OSToolbox)
WinCallProcess			:: !CSTR !CSTR !CSTR !CSTR !CSTR !CSTR !*OSToolbox -> ( !Bool, !Int, !*OSToolbox)

WinGetModulePath		:: {#Char}
WinFileModifiedDate		:: !{#Char} -> ( !Bool, !Int, !Int, !Int, !Int, !Int, !Int)
WinFileExists			:: !{#Char} ->  Bool

Rand					:: Int

ConsolePrint			:: !{#Char} !*OSToolbox ->  *OSToolbox

WinReleaseCString		:: !CSTR !*OSToolbox ->  *OSToolbox
WinGetCStringAndFree	:: !CSTR !*OSToolbox -> ( !{#Char}, !*OSToolbox)
WinGetCString			:: !CSTR !*OSToolbox -> ( !{#Char}, !*OSToolbox)
WinMakeCString			:: !{#Char} !*OSToolbox -> ( !CSTR, !*OSToolbox)

WinGetAppPath			:: CSTR

WinSetDoubleDownDist	:: !Int !*OSToolbox ->  *OSToolbox

WinKickOsThread			:: !CrossCallInfo !*OSToolbox -> ( !CrossCallInfo, !*OSToolbox)
WinKillOsThread			:: !*OSToolbox ->  *OSToolbox
WinStartOsThread		:: !*OSToolbox ->  *OSToolbox

WinCloseOs				:: !*OSToolbox ->  Bool
WinInitOs				:: ( !Bool, !*OSToolbox )

WinGetHorzResolution	:: Int
WinGetVertResolution	:: Int

WinMaxFixedWindowSize	:: ( !Int, !Int)
WinMaxScrollWindowSize	:: ( !Int, !Int)

//	PA: interfaces added for determining screen width and height.
WinScreenYSize			:: !*OSToolbox -> (!Int,!*OSToolbox)
WinScreenXSize			:: !*OSToolbox -> (!Int,!*OSToolbox)

WinMinimumWinSize		:: ( !Int, !Int)

//	PA: function added to get system metrics for width and height of scrollbars.
WinScrollbarSize		:: !*OSToolbox -> ( !Int, !Int, !*OSToolbox )

WinActivateShortcutTable:: !ACCLPTR !Int !*OSToolbox ->  *OSToolbox
WinCopyShortcutToTable	:: !Char !Int !Int !ACCLPTR !*OSToolbox ->  *OSToolbox
WinAllocShortcutTable	:: !Int !*OSToolbox -> ( !ACCLPTR, !*OSToolbox)

// RWS ...
WinSetShortcut			:: !Int !Char !*OSToolbox ->  *OSToolbox
//WinDestroyMenu			:: !Int !*OSToolbox ->  *OSToolbox	PA: implemented as crosscall routine
// .. RWS

//	PA: Win(Create/Destroy)ScreenHDC added to temporarily create a HDC of a screen.
//		Never use these values for a window or control.
WinCreateScreenHDC		:: !*OSToolbox -> PIC
WinDestroyScreenHDC		:: !PIC -> *OSToolbox

WinGetPicStringWidth	:: !{#Char} !PIC -> ( !Int, !PIC)
WinGetPicCharWidth		:: !Char !PIC -> ( !Int, !PIC)
WinGetStringWidth		:: !{#Char} !Fnt !Int !HDC !*OSToolbox -> ( !Int, !*OSToolbox)
WinGetCharWidth			:: !Char !Fnt !Int !HDC !*OSToolbox -> ( !Int, !*OSToolbox)

WinGetPicFontInfo		:: !PIC -> ( !Int, !Int, !Int, !Int, !PIC)
WinGetFontInfo			:: !Fnt !Int !HDC !*OSToolbox -> ( !Int, !Int, !Int, !Int, !*OSToolbox)
WinSetFontStyle			:: !Int !PIC ->  PIC
WinSetFontSize			:: !Int !PIC ->  PIC
WinSetFontName			:: !{#Char} !PIC ->  PIC
WinSetFont				:: !Fnt !PIC ->  PIC

//	PA: new routine to draw bitmaps.
WinDrawBitmap			:: !(!Int,!Int) !(!Int,!Int,!Int,!Int) !{#Char} !PIC -> PIC
// MW...
WinDrawResizedBitmap	:: !(!(!Int,!Int),!(!Int,!Int)) !(!Int,!Int) !(!Int,!Int) !{#Char} !PIC -> PIC
// ... MW

WinInvertPolygon		:: !PIC ->  PIC
WinErasePolygon			:: !PIC ->  PIC
WinFillPolygon			:: !PIC ->  PIC
WinDrawPolygon			:: !PIC ->  PIC
WinAddPolygonPoint		:: !Pt !*OSToolbox ->  *OSToolbox
WinStartPolygon			:: !Int !*OSToolbox ->  *OSToolbox
WinEndPolygon			:: !*OSToolbox -> *OSToolbox

WinInvertWedge			:: !Rect !Pt !Pt !PIC ->  PIC
WinEraseWedge			:: !Rect !Pt !Pt !PIC ->  PIC
WinFillWedge			:: !Rect !Pt !Pt !PIC ->  PIC
WinDrawWedge			:: !Rect !Pt !Pt !PIC ->  PIC

WinInvertCircle			:: !Pt !Int !PIC ->  PIC
WinEraseCircle			:: !Pt !Int !PIC ->  PIC
WinFillCircle			:: !Pt !Int !PIC ->  PIC
WinDrawCircle			:: !Pt !Int !PIC ->  PIC

WinInvertOval			:: !Rect !PIC ->  PIC
WinEraseOval			:: !Rect !PIC ->  PIC
WinFillOval				:: !Rect !PIC ->  PIC
WinDrawOval				:: !Rect !PIC ->  PIC

WinInvertRoundRectangle	:: !Rect !Int !Int !PIC ->  PIC
WinEraseRoundRectangle	:: !Rect !Int !Int !PIC ->  PIC
WinFillRoundRectangle	:: !Rect !Int !Int !PIC ->  PIC
WinDrawRoundRectangle	:: !Rect !Int !Int !PIC ->  PIC

WinCopyRectangle		:: !Rect !Pt !PIC ->  PIC
WinCopyRectangleTo		:: !Rect !Pt !PIC ->  PIC
WinMoveRectangle		:: !Rect !Pt !PIC ->  PIC
WinMoveRectangleTo		:: !Rect !Pt !PIC ->  PIC

WinInvertRectangle		:: !Rect !PIC ->  PIC
WinEraseRectangle		:: !Rect !PIC ->  PIC
WinFillRectangle		:: !Rect !PIC ->  PIC
WinDrawRectangle		:: !Rect !PIC ->  PIC

WinDrawChar				:: !Int !PIC ->  PIC
WinDrawString			:: !{#Char} !PIC ->  PIC

WinDrawCCurve			:: !Rect !Pt !Pt !RGBcolor !PIC ->  PIC
WinDrawCLine			:: !Pt !Pt !RGBcolor !PIC ->  PIC
WinDrawCPoint			:: !Pt !RGBcolor !PIC ->  PIC
WinDrawCurve			:: !Rect !Pt !Pt !PIC ->  PIC
WinDrawLine				:: !Pt !Pt !PIC ->  PIC
WinDrawPoint			:: !Pt !PIC ->  PIC

// PA: operations to create, modify and destroy polygon shapes.
WinAllocPolyShape		:: !Int !*OSToolbox -> (!Int,!*OSToolbox)
WinSetPolyPoint			:: !Int !Int !Int !Int !*OSToolbox -> *OSToolbox
WinFreePolyShape		:: !Int !*OSToolbox -> *OSToolbox
// PA: end of addition.

// PA: operations to create, modify and destroy regions.
WinCreateRectRgn		:: !Int !Int !Int !Int !*OSToolbox -> (!HRGN,!*OSToolbox)
WinCreatePolygonRgn		:: !Int !Int !Int !*OSToolbox -> (!HRGN,!*OSToolbox)
WinSetRgnToRect			:: !Int !Int !Int !Int !HRGN !*OSToolbox -> (!HRGN,!*OSToolbox)
WinCombineRgn			:: !HRGN !HRGN !HRGN !Int !*OSToolbox -> (!HRGN,!*OSToolbox)
WinGetRgnBox			:: !HRGN !*OSToolbox -> (!Int,!Int,!Int,!Int,!Bool,!*OSToolbox)
WinDeleteObject			:: !Int !*OSToolbox -> *OSToolbox
// PA: end of addition.

WinLinePen				:: !Pt !PIC ->  PIC
WinLinePenTo			:: !Pt !PIC ->  PIC

WinMovePen				:: !Pt !PIC ->  PIC
WinMovePenTo			:: !Pt !PIC ->  PIC

WinSetPattern			:: !Int !PIC ->  PIC

WinGetPenPos			:: !PIC -> (!Pt, !PIC)

WinSetMode				:: !Int !PIC ->  PIC

WinSetBackColor			:: !RGBcolor !PIC ->  PIC
WinSetPenColor			:: !RGBcolor !PIC ->  PIC
WinSetPenSize			:: !Int !PIC ->  PIC

WinClipPicture			:: !Rect !PIC ->  PIC
WinClipRgnPicture		:: !HRGN !PIC -> PIC			//	PA: operation to set the clipping region.
WinSetClipRgnPicture	:: !HRGN !PIC -> PIC			//	PA+++: new operation to completely set the clipping region.
WinGetClipRgnPicture	::       !PIC -> (!HRGN,!PIC)	//  PA+++: new operation to retrieve the current clipping region

WinDonePicture			:: !PIC -> ( !Int, !Int, !RGBcolor, !RGBcolor, !Pt, !Fnt, !PIC)
WinInitPicture			:: !Int !Int !RGBcolor !RGBcolor !Pt !Fnt !Pt !PIC ->  PIC
WinGetTickCount			:: !*OSToolbox -> (!Int, !*OSToolbox)
